﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Text;
using HaTeam.Dd.Model;
using System.Data.SqlClient;
using System.Data;
using DotNet.FrameWork.Data;

namespace HteamDd.Web.ashx
{
    /// <summary>
    /// Dd_FeverTag 的摘要说明
    /// 从数据库读取热门标签及标签并绑定到页面
    /// </summary>
    public class Dd_FerverTag : IHttpHandler
    {

        protected StringBuilder json = new StringBuilder();
        List<HotLabel> lp = new List<HotLabel>();
        //定义全局变量，判断读取问题。
        bool noData = false;

        public void ProcessRequest(HttpContext context)
        {
            json.Append("[");
            context.Response.ContentType = "text/plain";
            bool isfirst = Convert.ToBoolean(context.Request["isfirst"]);
            int pageid = Convert.ToInt32(context.Request["TimeNum"]);
            if (pageid == 3 && isfirst == true) //第一次加载
            {
                GetData(1, 18);
            }
            else
            {
                GetData(pageid, 6);
            }
            context.Response.Write(json + "|" + noData);
        }

        /// <summary>
        /// 获取数据，第一次加载六条，1，18.后一次4，6
        /// </summary>
        /// <param name="pageid">第几页</param>
        /// <param name="Count">每页显示多少条数据</param>
        public void GetData(int pageid, int Count)
        {
            SqlConnection con = new SqlConnection(PubConstant.ConnectionString);
            con.Open();
            SqlCommand cmd = new SqlCommand("Dd_pagePicture", con);
            cmd.Parameters.Add(new SqlParameter("@PageNum", pageid));
            cmd.Parameters.Add(new SqlParameter("@OnePageCount", Count));
            cmd.CommandType = CommandType.StoredProcedure;
            SqlDataReader reader = cmd.ExecuteReader();
            try
            {
                if (reader.HasRows)
                {
                    while (reader.Read())
                    {
                        HotLabel pic = new HotLabel();
                        string[] images = reader.GetValue(0).ToString().Split('|');
                        pic.Fever = images[0] + "/" + images[1]; //路径,还需要修改
                        pic.lable = reader.GetValue(1).ToString();   //标签名
                        lp.Add(pic);
                    }
                }

                else  //若数据库中没有数据了，则重新读取
                {
                    noData = true;
                    GetData(1, Count);
                    return;
                }
                if (lp.Count < Count)  //读取的数据不够，重头读取剩余的数据
                {
                    noData = true;
                    GetData(1, Count - lp.Count);
                    return;
                }
                DataToJson();
            }
            catch (Exception ex)
            {
                con.Close();
            }
            finally{con.Close();}
        }

        /// <summary>
        /// 第一次绑定前十六张图片（由于现在数据少，只绑定前六张）
        /// </summary>
        public void DataToJson()
        {
            for (int i = 0; i < lp.Count; i++)
            {
                json.Append("{\"pic_Url\":" + "\"" + lp[i].Fever.ToString() + "\",");
                json.Append("\"pic_Tag\":" + "\"" + lp[i].lable.ToString() + "\"},");
            }
            json.Remove(json.Length - 1, 1);
            json.Append("]");
        }



        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}